<?php
require_once("../includes/db.php");
require_once("../includes/dompdf/autoload.inc.php");
use Dompdf\Dompdf;

$dompdf = new Dompdf();
$html = "<h2>Lembaran Imbangan</h2>";

$akaun = $conn->query("SELECT * FROM chart_of_accounts");
$rows = [];

while ($row = $akaun->fetch_assoc()) {
    $kod = $row['kod_akaun'];
    $kategori = $row['kategori'];
    $nama = $row['nama_akaun'];
    $baki_q = $conn->query("SELECT SUM(amaun) AS jumlah FROM transactions WHERE kod_akaun='$kod'");
    $baki = $baki_q->fetch_assoc()['jumlah'] ?? 0;
    $rows[] = [$kategori, $nama, $baki];
}

$kategori_list = ['Aset', 'Liabiliti', 'Ekuiti'];
foreach ($kategori_list as $kategori) {
    $html .= "<h3>{$kategori}</h3><ul>";
    $jumlah = 0;
    foreach ($rows as $row) {
        if ($row[0] === $kategori) {
            $html .= "<li>{$row[1]}: RM " . number_format($row[2], 2) . "</li>";
            $jumlah += $row[2];
        }
    }
    $html .= "</ul><strong>Jumlah {$kategori}: RM " . number_format($jumlah, 2) . "</strong>";
}

$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "portrait");
$dompdf->render();
$dompdf->stream("lembaran_imbangan.pdf", ["Attachment" => false]);
exit;
?>
