<?php
require_once("includes/auth_check.php");
require_once("includes/db.php");

// Dapatkan jumlah pendapatan dan perbelanjaan ikut bulan
$bulan = [];
$pendapatan = [];
$perbelanjaan = [];

for ($i = 1; $i <= 12; $i++) {
    $bulan_label = date("M", mktime(0, 0, 0, $i, 10));
    $bulan[] = $bulan_label;

    $sql_pendapatan = "SELECT SUM(amaun) as jumlah FROM transactions 
        WHERE MONTH(tarikh) = $i AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Pendapatan')";
    $sql_perbelanjaan = "SELECT SUM(amaun) as jumlah FROM transactions 
        WHERE MONTH(tarikh) = $i AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Perbelanjaan')";

    $pendapatan_result = $conn->query($sql_pendapatan)->fetch_assoc();
    $perbelanjaan_result = $conn->query($sql_perbelanjaan)->fetch_assoc();

    $pendapatan[] = $pendapatan_result['jumlah'] ?? 0;
    $perbelanjaan[] = abs($perbelanjaan_result['jumlah'] ?? 0);
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Dashboard - Statistik</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<div class="container mt-4">
  <h3>Statistik Bulanan (Pendapatan vs Perbelanjaan)</h3>
  <canvas id="grafStatistik"></canvas>
</div>

<script>
const ctx = document.getElementById('grafStatistik').getContext('2d');
const chart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?php echo json_encode($bulan); ?>,
        datasets: [
            {
                label: 'Pendapatan',
                backgroundColor: 'green',
                data: <?php echo json_encode($pendapatan); ?>
            },
            {
                label: 'Perbelanjaan',
                backgroundColor: 'red',
                data: <?php echo json_encode($perbelanjaan); ?>
            }
        ]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'top' },
            title: { display: true, text: 'Statistik Kewangan Bulanan' }
        }
    }
});
</script>
</body>
</html>
