<?php
require_once("includes/auth_check.php");
require_once("includes/db.php");

// Tetapan lalai bulan & tahun semasa
$bulan_terpilih = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
$tahun_terpilih = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

$pendapatan = 0;
$perbelanjaan = 0;

$sql_pendapatan = "SELECT SUM(amaun) AS jumlah FROM transactions 
    WHERE MONTH(tarikh) = $bulan_terpilih AND YEAR(tarikh) = $tahun_terpilih
    AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Pendapatan')";

$sql_perbelanjaan = "SELECT SUM(amaun) AS jumlah FROM transactions 
    WHERE MONTH(tarikh) = $bulan_terpilih AND YEAR(tarikh) = $tahun_terpilih
    AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Perbelanjaan')";

$pendapatan_result = $conn->query($sql_pendapatan)->fetch_assoc();
$perbelanjaan_result = $conn->query($sql_perbelanjaan)->fetch_assoc();

$pendapatan = $pendapatan_result['jumlah'] ?? 0;
$perbelanjaan = abs($perbelanjaan_result['jumlah'] ?? 0);
$lebihan = $pendapatan - $perbelanjaan;
?>
<!DOCTYPE html>
<html>
<head>
  <title>Statistik Bulanan</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
  <h3>Statistik Kewangan Bulanan</h3>
  <form method="get" class="row g-3 mb-4">
    <div class="col-auto">
      <label for="bulan" class="form-label">Bulan</label>
      <select name="bulan" id="bulan" class="form-select">
        <?php for ($b = 1; $b <= 12; $b++): ?>
          <option value="<?= $b ?>" <?= $b == $bulan_terpilih ? 'selected' : '' ?>>
            <?= date('F', mktime(0,0,0,$b,10)) ?>
          </option>
        <?php endfor; ?>
      </select>
    </div>
    <div class="col-auto">
      <label for="tahun" class="form-label">Tahun</label>
      <input type="number" name="tahun" id="tahun" value="<?= $tahun_terpilih ?>" class="form-control">
    </div>
    <div class="col-auto d-flex align-items-end">
      <button type="submit" class="btn btn-primary">Tapis</button>
    </div>
  </form>

  <div class="card">
    <div class="card-body">
      <h5>Pendapatan: RM <?= number_format($pendapatan, 2) ?></h5>
      <h5>Perbelanjaan: RM <?= number_format($perbelanjaan, 2) ?></h5>
      <h5>Lebihan / Defisit: RM <?= number_format($lebihan, 2) ?></h5>
    </div>
  </div>
</div>
</body>
</html>
