<?php
require_once("includes/auth_check.php");
require_once("includes/db.php");

function jumlahKategori($kategori, $conn) {
    $query = "SELECT SUM(amaun) AS jumlah FROM transactions 
              WHERE kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='$kategori')";
    $result = $conn->query($query);
    $row = $result->fetch_assoc();
    return $row['jumlah'] ?? 0;
}

$total_pendapatan = jumlahKategori('Pendapatan', $conn);
$total_perbelanjaan = jumlahKategori('Perbelanjaan', $conn);
$lebihan = $total_pendapatan - abs($total_perbelanjaan);
?>
<!DOCTYPE html>
<html>
<head>
  <title>Dashboard - Sistem Akaun NGO</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Sistem Akaun NGO</a>
    <div class="d-flex">
      <a href="logout.php" class="btn btn-outline-light">Log Keluar</a>
    </div>
  </div>
</nav>

<div class="container my-4">
  <h3>Selamat Datang, <?php echo $_SESSION['user']['nama']; ?></h3>

  <div class="row mt-4">
    <div class="col-md-4">
      <div class="card text-bg-success mb-3">
        <div class="card-body">
          <h5 class="card-title">Jumlah Pendapatan</h5>
          <p class="card-text">RM <?php echo number_format($total_pendapatan, 2); ?></p>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card text-bg-danger mb-3">
        <div class="card-body">
          <h5 class="card-title">Jumlah Perbelanjaan</h5>
          <p class="card-text">RM <?php echo number_format(abs($total_perbelanjaan), 2); ?></p>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card text-bg-info mb-3">
        <div class="card-body">
          <h5 class="card-title">Lebihan / Defisit</h5>
          <p class="card-text">RM <?php echo number_format($lebihan, 2); ?></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card text-bg-secondary">
    <div class="card-body">
      <h5 class="card-title">Muat Naik Resit ke Google Drive</h5>
      <form action="upload_manual.php" method="post" enctype="multipart/form-data">
        <input type="file" name="fail_resit" class="form-control mb-2" required>
        <button type="submit" class="btn btn-light">Muat Naik</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
