<?php
require_once __DIR__ . '/google-api/vendor/autoload.php';

function uploadToDrive($localFilePath, $filenameInDrive) {
    $client = new Google_Client();
    $client->setAuthConfig(__DIR__ . '/google-api/credentials.json');
    $client->addScope(Google_Service_Drive::DRIVE_FILE);
    $service = new Google_Service_Drive($client);

    $fileMetadata = new Google_Service_Drive_DriveFile([
        'name' => $filenameInDrive
    ]);

    $content = file_get_contents($localFilePath);

    $file = $service->files->create($fileMetadata, [
        'data' => $content,
        'mimeType' => mime_content_type($localFilePath),
        'uploadType' => 'multipart',
        'fields' => 'id'
    ]);

    return $file->id;
}
?>
